//=============================================================================
// WorkBenchMenuMain
//=============================================================================

class WorkBenchMenuBreakdownRifle expands MenuUIWindow;

//Universals
var DeusExPlayer Player;
var PartsBag Bench;
var MSMassEffectMutator Mutator;

//Window Specifics
var MenuUIActionButtonWindow exitButton;
var localized string exitButtonText;

var class<CraftingStock> CurStock;
var class<CraftingBody> CurBody;
var class<CraftingFeed> CurFeed;
var class<CraftingPin> CurPin;
var class<CraftingBarrel> CurBarrel;
var CustomRifle CurWeapon;

var Window Overlay1, Overlay2, PinOverlay;
var Window StockDisplay, BodyDisplay, FeedDisplay, PinDisplay, BarrelDisplay;

var ModifiedPersonaTextWindow Durabilities[5];

var ModifiedPersonaTextWindow  StatDisplay;
var MenuUIEditWindow CustomNameField;

var Window ColorDisplay;
var ColorButtonForward NextWeapon;
var ColorButtonBackward PrevWeapon;
var int CurColor; //White, Yellow, Green, Blue, Purple, Red, Orange.
var String ColorPickerValues[7]; //these might be slightly off, but it works.

var PersonaActionButtonWindow BreakdownButton;

var Window Last;

// ----------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window... it's way down there...
// In the meantime, here's a lot of precautionary vomit!
// ----------------------------------------------------------------------


function bool CanPushScreen(Class <DeusExBaseWindow> newScreen)
{
 return false;
}

function bool CanStack()
{
 return false;
}

event bool VirtualKeyPressed(EInputKey key, bool bRepeat)
{
 return false;
}

event bool RawKeyPressed(EInputKey key, EInputState iState, bool bRepeat)
{
 return false;
}

event InitWindow()
{
 local int i, j;

	Super.InitWindow();
        SetTitle("Custom Rifle Breakdown");
        exitButton = winButtonBar.AddButton(exitButtonText, HALIGN_Left);
	
	CreateOverlays();
	CreateButtons();
        CreateDurabilities();
	CreateTextDisplay();

	CustomNameField = CreateMenuEditWindow(347, 272, 132, 24, winClient);
	CustomNameField.SetText("");
	CustomNameField.SetSensitivity(False);
}

function CreateTextDisplay()
{
 StatDisplay = ModifiedPersonaTextWindow(NewChild(Class'ModifiedPersonaTextWindow'));
 StatDisplay.SetPos(16, 268);
 StatDisplay.SetSize(240, 96);
 StatDisplay.SetFont(Font'FontMenuHeaders');
}

function CreateDurabilities()
{
 Durabilities[0] = ModifiedPersonaTextWindow(NewChild(Class'ModifiedPersonaTextWindow'));
 Durabilities[0].SetPos(67, 107);
 Durabilities[0].SetSize(96, 20);
 Durabilities[0].SetFont(Font'FontMenuHeaders');
 Durabilities[1] = ModifiedPersonaTextWindow(NewChild(Class'ModifiedPersonaTextWindow'));
 Durabilities[1].SetPos(203, 103);
 Durabilities[1].SetSize(96, 20);
 Durabilities[1].SetFont(Font'FontMenuHeaders');
 Durabilities[2] = ModifiedPersonaTextWindow(NewChild(Class'ModifiedPersonaTextWindow'));
 Durabilities[2].SetPos(227, 139);
 Durabilities[2].SetSize(96, 20);
 Durabilities[2].SetFont(Font'FontMenuHeaders');
 Durabilities[3] = ModifiedPersonaTextWindow(NewChild(Class'ModifiedPersonaTextWindow'));
 Durabilities[3].SetPos(172, 91);
 Durabilities[3].SetSize(96, 20);
 Durabilities[3].SetFont(Font'FontMenuHeaders');
 Durabilities[4] = ModifiedPersonaTextWindow(NewChild(Class'ModifiedPersonaTextWindow'));
 Durabilities[4].SetPos(375, 84);
 Durabilities[4].SetSize(96, 20);
 Durabilities[4].SetFont(Font'FontMenuHeaders');
}

function CreateButtons()
{
 	NextWeapon = ColorButtonForward(NewChild(Class'ColorButtonForward'));
	NextWeapon.SetPos(490, 288);
 	PrevWeapon = ColorButtonBackward(NewChild(Class'ColorButtonBackward'));
	PrevWeapon.SetPos(324, 288);
	
	BreakdownButton = PersonaActionButtonWindow(NewChild(Class'PersonaActionButtonWindow'));
	BreakdownButton.SetPos(448, 368);
	BreakdownButton.SetButtonText("|p4Breakdown");
	BreakdownButton.SetSensitivity(False);
}

function CreateOverlays()
{
	Overlay1 = NewChild(Class'Window');
	SetupOverlay(Overlay1, 0, 0, 256, 256);
	Overlay1.SetBackground(Texture'WorkbenchRifleOverlay1');

	Overlay2 = NewChild(Class'Window');
	SetupOverlay(Overlay2, 256, 0, 256, 256);	
	Overlay2.SetBackground(Texture'WorkbenchRifleOverlay2');
	
	StockDisplay = NewChild(Class'Window');
	SetupOverlay(StockDisplay, 0, 0, 256, 256);
		
	FeedDisplay = NewChild(Class'Window');
	SetupOverlay(FeedDisplay, 201, 107, 128, 128);

	BarrelDisplay = NewChild(Class'Window');
	SetupOverlay(BarrelDisplay, 256, 0, 256, 256);

	BodyDisplay = NewChild(Class'Window');
	SetupOverlay(BodyDisplay, 117, 75, 256, 128);

	//Reinforce the pin overlay, otherwise it's invisible
	
	PinOverlay = NewChild(Class'Window');
	SetupOverlay(PinOverlay, 0, 0, 256, 140);
	PinOverlay.SetBackground(Texture'WorkBenchRiflePinOverlay');
	
	PinDisplay = NewChild(Class'Window');
	SetupOverlay(PinDisplay, 0, 0, 256, 128);

	ColorDisplay = NewChild(Class'Window');
	SetupOverlay(ColorDisplay, 375, 352, 32, 32);
	ColorDisplay.SetBackground(Texture'WBMWhite');	
}

function SetupOverlay(Window Win, int PosX, int PosY, int WidthX, int HeightY)
{
	win.SetBackgroundStyle(DSTY_Masked);
	win.SetPos(PosX, PosY);
	win.SetSize(WidthX, HeightY);
}

function UpdateIcons()
{
 if (CurWeapon != None)
 {
  if (CurWeapon.CurStockDurability > 0) StockDisplay.SetBackground(CurStock.Default.BenchIcon);
  if (CurWeapon.CurBodyDurability > 0) BodyDisplay.SetBackground(CurBody.Default.BenchIcon);
  if (CurWeapon.CurFeedDurability > 0) FeedDisplay.SetBackground(CurFeed.Default.BenchIcon);
  if (CurWeapon.CurPinDurability > 0) PinDisplay.SetBackground(CurPin.Default.BenchIcon);
  if (CurWeapon.CurBarrelDurability > 0) BarrelDisplay.SetBackground(CurBarrel.Default.BenchIcon);
 }
 
 UpdateStats();
 UpdateColor();
}

function UpdateColor()
{
 if (CurWeapon == None) return;
 
 CurColor = GetCurrentColor();
 
 if (CurColor == 0) ColorDisplay.SetBackground(Texture'WBMWhite');
 if (CurColor == 1) ColorDisplay.SetBackground(Texture'WBMGold');
 if (CurColor == 2) ColorDisplay.SetBackground(Texture'WBMGreen');
 if (CurColor == 3) ColorDisplay.SetBackground(Texture'WBMBlue');
 if (CurColor == 4) ColorDisplay.SetBackground(Texture'WBMPurple');
 if (CurColor == 5) ColorDisplay.SetBackground(Texture'WBMRed');
 if (CurColor == 6) ColorDisplay.SetBackground(Texture'WBMOrange');
}

function int GetCurrentColor()
{
 local int i;
 
 for(i=0; i<7; i++)
 {
  if (CurWeapon.CustomColor ~= ColorPickerValues[i])
  {
   return i;
  }
 }
 
 return 0;
}

function UpdateStats()
{
 if (CurWeapon == None) BreakdownButton.SetSensitivity(False);
 if (CurWeapon != None && !CurWeapon.bDeleteMe) BreakdownButton.SetSensitivity(True);
 
 StatDisplay.SetText(BuildWeaponStats());
 
 if (CurWeapon.CurStockDurability > 0) Durabilities[0].SetText(CurWeapon.CurStockDurability$"/"$CurWeapon.StockDurability);
 if (CurWeapon.CurBodyDurability > 0) Durabilities[1].SetText(CurWeapon.CurBodyDurability$"/"$CurWeapon.BodyDurability);
 if (CurWeapon.CurFeedDurability > 0) Durabilities[2].SetText(CurWeapon.CurFeedDurability$"/"$CurWeapon.FeedDurability);
 if (CurWeapon.CurPinDurability > 0) Durabilities[3].SetText(CurWeapon.CurPinDurability$"/"$CurWeapon.PinDurability);
 if (CurWeapon.CurBarrelDurability > 0) Durabilities[4].SetText(CurWeapon.CurBarrelDurability$"/"$CurWeapon.BarrelDurability);
 
 if (CurWeapon.CurStockDurability <= 0 || CurStock == None) Durabilities[0].SetText("");
 if (CurWeapon.CurBodyDurability <= 0 || CurBody == None) Durabilities[1].SetText("");
 if (CurWeapon.CurFeedDurability <= 0 || CurFeed == None) Durabilities[2].SetText("");
 if (CurWeapon.CurPinDurability <= 0 || CurPin == None) Durabilities[3].SetText("");
 if (CurWeapon.CurBarrelDurability <= 0 || CurBarrel == None) Durabilities[4].SetText("");
 
 CustomNameField.SetText(CurWeapon.CustomName);
}

function UpdateParts()
{
 CurStock = class<CraftingStock>(DynamicLoadObject(CurWeapon.StockName, class'Class'));
 CurBody = class<CraftingBody>(DynamicLoadObject(CurWeapon.BodyName, class'Class'));
 CurFeed = class<CraftingFeed>(DynamicLoadObject(CurWeapon.FeedName, class'Class'));
 CurPin = class<CraftingPin>(DynamicLoadObject(CurWeapon.PinName, class'Class'));
 CurBarrel = class<CraftingBarrel>(DynamicLoadObject(CurWeapon.BarrelName, class'Class'));
}

simulated function String FormatFloatString(float value, float precision)
{
	local string str;

	if (precision == 0.0)
		return "ERR";

	// build integer part
	str = String(Int(value));

	// build decimal part
	if (precision < 1.0)
	{
		value -= Int(value);
		str = str $ "." $ String(Int((0.5 * precision) + value * (1.0 / precision)));
	}

	return str;
}

function BreakdownWeapon()
{
 local CraftingPart C;
 local class<CraftingAccesory> TempAccesory;
 
 local bool bHasBurst, bHasAuto;
 local int Recoil, Weight, Accuracy, Capacity, Caliber;
 local float Reload, Rate;
 
 if (CurWeapon == None || CurWeapon.bDeleteMe)
 {
  Bench.PlaySound(Sound'InsufficientScrap');
  return;
 }
 
 if (CurWeapon.CurStockDurability > 0)
 {
  C = Bench.Spawn(CurStock,,,Bench.Location + vect(0,0,30));
  C.CurDurability = CurWeapon.CurStockDurability;
  C.Frob(Player, None);
 }

 if (CurWeapon.CurBodyDurability > 0)
 {
  C = Bench.Spawn(CurBody,,,Bench.Location + vect(0,0,30));
  C.CurDurability = CurWeapon.CurBodyDurability;
  C.Frob(Player, None);
 }
 
 if (CurWeapon.CurFeedDurability > 0)
 {
  C = Bench.Spawn(CurFeed,,,Bench.Location + vect(0,0,30));
  C.CurDurability = CurWeapon.CurFeedDurability;
  C.Frob(Player, None);
 }
 
 if (CurWeapon.CurPinDurability > 0)
 {
  C = Bench.Spawn(CurPin,,,Bench.Location + vect(0,0,30));
  C.CurDurability = CurWeapon.CurPinDurability;
  C.Frob(Player, None);
 }
 
 if (CurWeapon.CurBarrelDurability > 0)
 {
  C = Bench.Spawn(CurBarrel,,,Bench.Location + vect(0,0,30));
  C.CurDurability = CurWeapon.CurBarrelDurability;
  C.Frob(Player, None);
 }
 
 if (CurWeapon.CurAccesoryDurability > 0)
 {
  TempAccesory = class<CraftingAccesory>(DynamicLoadObject(CurWeapon.AccesoryName, class'Class'));
  
  C = Bench.Spawn(TempAccesory,,,Bench.Location + vect(0,0,30));
  C.CurDurability = CurWeapon.CurAccesoryDurability;
  C.Frob(Player, None); 
 }
 
 CurWeapon.Destroy();
 CurStock = None;
 CurBody = None;
 CurFeed = None;
 CurPin = None;
 CurBarrel = None; 
 
 BreakdownButton.SetSensitivity(False);
 
 CustomNameField.SetText("");
 CurColor = 0;
 
 Bench.PlaySound(Sound'BreakdownPart');
 
 UpdateIcons();
 ClearIcons();
}

function ClearIcons()
{
 if (CurStock == None) StockDisplay.SetBackground(None);
 if (CurBody == None) BodyDisplay.SetBackground(None);
 if (CurFeed == None) FeedDisplay.SetBackground(None);
 if (CurPin == None) PinDisplay.SetBackground(None);
 if (CurBarrel == None) BarrelDisplay.SetBackground(None);
}

//=============================
//NO STOPPING THIS ONE.
//=============================
function AbsClearIcons()
{
 StockDisplay.SetBackground(None);
 BodyDisplay.SetBackground(None);
 FeedDisplay.SetBackground(None);
 PinDisplay.SetBackground(None);
 BarrelDisplay.SetBackground(None);
}

function String BuildWeaponStats()
{
 local string S, Modes, Caliber, RateS, ReloadS;
 local int Recoil, Weight, Accuracy, Capacity;
 local float Reload, Rate;
 
 if (CurWeapon == None || CurWeapon.bDeleteMe) return "";
 
 Weight = 25;
 Accuracy = 75;
 Reload = 3;
 Rate = 0.1;
 Recoil = 5;
 
 if (CurBarrel != None) 
 {
  Caliber = "Caliber: "$FormatFloatString(  float(CurBarrel.Default.CaliberType) / 100, 0.01  )$"mm";
  Accuracy += CurBarrel.Default.AccuracyMod * 5;
  Recoil += CurBarrel.Default.RecoilMod;
 }
 if (CurBody != None)
 {
  Weight += CurBody.Default.WeightMod;
 }
 if (CurFeed != None)
 {
  Weight += CurFeed.Default.WeightMod;
  Capacity = CurFeed.Default.CapacityMod;
  Reload += CurFeed.Default.ReloadMod;
 }
 if (CurPin != None)
 {
  Reload += CurPin.Default.ReloadMod;
  Rate += CurPin.Default.RateMod;
  
  Modes = "Modes: Semi ";
  if (CurPin.Default.bHasBurst) Modes = Modes@"Burst";
  if (CurPin.Default.bHasAuto) Modes = Modes@"Auto ";
 }
 if (CurStock != None)
 {
  Recoil += CurStock.Default.RecoilMod;
  Weight += CurStock.Default.WeightMod;
 }
 if (CurWeapon.CurStockDurability <= 0)
 {
  Recoil = 10;
 }
 
 ReloadS = FormatFloatString(Reload, 0.1);
 RateS = FormatFloatString(Rate, 0.01);
 
 S = Modes@Caliber$CR()$"Refire: "$RateS@"Reload: "$ReloadS$CR()$"Recoil: "$Recoil@"Weight: "$Weight$CR()$"Accuracy: "$Accuracy$"%"@"Capacity: "$Capacity@"Rounds";
 
 return S;
}

function bool ButtonActivated( Window buttonPressed )
{
	local bool bHandled;
	local name TempName;

	bHandled = True;

	Super.ButtonActivated(buttonPressed);

	switch(buttonPressed)
	{
		case exitButton:
			//Ralph.ChargeTheGates(TempName);
			// Do stuff

			Last.Show(True);

			root.PopWindow();
			bHandled = True;
			break;

		case NextWeapon:
			ForwardWeapon();
			bHandled = True;
			break;
		case PrevWeapon:
			BackwardWeapon();
			bHandled = True;
			break;

		case BreakdownButton:
			BreakdownWeapon();
			bHandled = True;
			break;

		default:
			bHandled = False;
			break;
	}

	/*if (ButtonPressed != exitButton)
	{
		UpdateInfo();
	}*/

	return bHandled;
}

//==================================================
//++++++++++++++++++++++++++++++++++++++++++++++++++
//NEXT PART FUNCTIONS BEGIN
//++++++++++++++++++++++++++++++++++++++++++++++++++
//==================================================

function ForwardWeapon()
{
 local CustomRifle P, Pick, First, Last;
 local bool bNext;
 
 forEach Player.AllActors(class'CustomRifle', P)
 {
  if (P.Owner == Player)
  {
   if (First == None) First = P;
   Last = P;
   
   if (bNext)
   {
    Pick = P;
    break;
   }
   if (CurWeapon == None)
   {
    Pick = First;
    break;
   }
   
   if (P == CurWeapon) bNext = True;
  }
 }
 
 if (Pick == None)
 {
  Pick = First;
 }
 
 AbsClearIcons();
 CurWeapon = Pick;
 UpdateParts();
 UpdateIcons();
}

function BackwardWeapon()
{
 local CustomRifle P, Pick, First, Last;
 
 forEach Player.AllActors(class'CustomRifle', P)
 {
  if (P.Owner == Player)
  {
   if (First == None) First = P;
   
   if (P == CurWeapon && P != First)
   {
    Pick = Last;
    break;
   }
   
   Last = P;
  }
 }
 
 if (CurWeapon == None || Pick == None)
 {
  Pick = Last;
 }

 AbsClearIcons();
 CurWeapon = Pick;
 UpdateParts();
 UpdateIcons();
}

//==================================================
//--------------------------------------------------
//PREV PART FUNCTIONS END
//--------------------------------------------------
//==================================================

function CraftRifle()
{
}

defaultproperties
{
     ColorPickerValues(0)="|cffffff"
     ColorPickerValues(1)="|ce5e500"
     ColorPickerValues(2)="|c20a748"
     ColorPickerValues(3)="|c0099db"
     ColorPickerValues(4)="|c9a459b"
     ColorPickerValues(5)="|cdf1b22"
     ColorPickerValues(6)="|cff7825"

     Title="Custom Rifle Breakdown"
     exitButtonText="Done"
     ClientWidth=512
     ClientHeight=384

     clientTextures(0)=Texture'WorkBenchRifleBG1'
     clientTextures(1)=Texture'WorkBenchRifleBG2'
     clientTextures(2)=Texture'WorkBenchRifleBG3'
     clientTextures(3)=Texture'WorkBenchRifleBG4'

     bActionButtonBarActive=True
     bUsesHelpWindow=False
     ScreenType=ST_Persona
     TextureRows=2
     TextureCols=2
     exitButtonText="Cancel"

}
